<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\DocumentNiveau;
use App\Models\Niveau;
use Illuminate\Http\Request;

class DocumentNiveauController extends Controller
{
    public function create(Niveau $niveau)
    {
        return view('admin.documents-niveau.create', compact('niveau'));
    }

    public function store(Request $request, Niveau $niveau)
    {
        $validated = $request->validate([
            'intitule' => 'required|string|max:255',
            'description' => 'nullable|string',
            'obligatoire' => 'boolean',
            'ordre' => 'nullable|integer',
        ]);

        $validated['obligatoire'] = $request->has('obligatoire');
        $validated['ordre'] = $validated['ordre'] ?? DocumentNiveau::where('niveau_id', $niveau->id)->max('ordre') + 1;

        $niveau->documentsNiveau()->create($validated);

        return redirect()->route('admin.filieres.show', $niveau->filiere_id)
            ->with('success', 'Document requis ajoute avec succes.');
    }

    public function edit(DocumentNiveau $documentNiveau)
    {
        $documentNiveau->load('niveau.filiere');
        return view('admin.documents-niveau.edit', compact('documentNiveau'));
    }

    public function update(Request $request, DocumentNiveau $documentNiveau)
    {
        $validated = $request->validate([
            'intitule' => 'required|string|max:255',
            'description' => 'nullable|string',
            'obligatoire' => 'boolean',
            'ordre' => 'nullable|integer',
        ]);

        $validated['obligatoire'] = $request->has('obligatoire');

        $documentNiveau->update($validated);

        return redirect()->route('admin.filieres.show', $documentNiveau->niveau->filiere_id)
            ->with('success', 'Document requis mis a jour avec succes.');
    }

    public function destroy(DocumentNiveau $documentNiveau)
    {
        $filiereId = $documentNiveau->niveau->filiere_id;
        $documentNiveau->delete();

        return redirect()->route('admin.filieres.show', $filiereId)
            ->with('success', 'Document requis supprime avec succes.');
    }
}
