<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Frais;
use App\Models\Niveau;
use Illuminate\Http\Request;

class FraisController extends Controller
{
    public function edit(Niveau $niveau)
    {
        $niveau->load('filiere');
        $frais = $niveau->frais ?? new Frais();
        return view('admin.frais.edit', compact('niveau', 'frais'));
    }

    public function update(Request $request, Niveau $niveau)
    {
        $validated = $request->validate([
            'montant_total' => 'required|numeric|min:0',
            'tranche_1' => 'nullable|numeric|min:0',
            'tranche_2' => 'nullable|numeric|min:0',
            'tranche_3' => 'nullable|numeric|min:0',
            'frais_inscription' => 'nullable|numeric|min:0',
        ]);

        $niveau->frais()->updateOrCreate(
            ['niveau_id' => $niveau->id],
            $validated
        );

        return redirect()->route('admin.filieres.show', $niveau->filiere_id)
            ->with('success', 'Frais mis a jour avec succes.');
    }
}
