<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Matiere;
use App\Models\Niveau;
use Illuminate\Http\Request;

class MatiereController extends Controller
{
    public function create(Niveau $niveau)
    {
        return view('admin.matieres.create', compact('niveau'));
    }

    public function store(Request $request, Niveau $niveau)
    {
        $validated = $request->validate([
            'nom' => 'required|string|max:255',
            'coefficient' => 'required|integer|min:1',
            'statut' => 'boolean',
            'ordre' => 'nullable|integer',
        ]);

        $validated['statut'] = $request->has('statut');
        $validated['ordre'] = $validated['ordre'] ?? Matiere::where('niveau_id', $niveau->id)->max('ordre') + 1;

        $niveau->matieres()->create($validated);

        return redirect()->route('admin.filieres.show', $niveau->filiere_id)
            ->with('success', 'Matiere ajoutee avec succes.');
    }

    public function edit(Matiere $matiere)
    {
        $matiere->load('niveau.filiere');
        return view('admin.matieres.edit', compact('matiere'));
    }

    public function update(Request $request, Matiere $matiere)
    {
        $validated = $request->validate([
            'nom' => 'required|string|max:255',
            'coefficient' => 'required|integer|min:1',
            'statut' => 'boolean',
            'ordre' => 'nullable|integer',
        ]);

        $validated['statut'] = $request->has('statut');

        $matiere->update($validated);

        return redirect()->route('admin.filieres.show', $matiere->niveau->filiere_id)
            ->with('success', 'Matiere mise a jour avec succes.');
    }

    public function destroy(Matiere $matiere)
    {
        $filiereId = $matiere->niveau->filiere_id;
        $matiere->delete();

        return redirect()->route('admin.filieres.show', $filiereId)
            ->with('success', 'Matiere supprimee avec succes.');
    }
}
