<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Niveau;
use App\Models\Filiere;
use Illuminate\Http\Request;

class NiveauController extends Controller
{
    public function edit(Niveau $niveau)
    {
        $niveau->load(['filiere', 'matieres', 'frais', 'documentsNiveau']);
        return view('admin.niveaux.edit', compact('niveau'));
    }

    public function update(Request $request, Niveau $niveau)
    {
        $validated = $request->validate([
            'nom' => 'required|string|max:255',
            'statut' => 'boolean',
        ]);

        $validated['statut'] = $request->has('statut');

        $niveau->update($validated);

        return redirect()->route('admin.filieres.show', $niveau->filiere_id)
            ->with('success', 'Niveau mis a jour avec succes.');
    }
}
