<?php

namespace App\Http\Controllers;

use App\Models\Inscription;
use App\Models\Message;
use App\Models\Setting;
use App\Models\Statistic;
use App\Models\Faq;
use App\Models\DocumentRequis;
use App\Models\Filiere;
use App\Models\Niveau;
use Illuminate\Http\Request;

class FrontController extends Controller
{
    public function accueil()
    {
        $filieres = Filiere::actif()->ordre()->get();
        $settings = Setting::first();
        return view('front.accueil', compact('filieres', 'settings'));
    }

    public function aPropos()
    {
        return view('front.a-propos');
    }

    public function programmes()
    {
        $filieres = Filiere::actif()->ordre()->with(['niveaux' => function($query) {
            $query->where('statut', true)->with(['matieres' => function($q) {
                $q->where('statut', true)->orderBy('ordre');
            }, 'frais', 'documentsNiveau' => function($q) {
                $q->orderBy('ordre');
            }]);
        }])->get();
        $statistics = Statistic::actif()->ordre()->get();
        return view('front.programmes', compact('filieres', 'statistics'));
    }

    public function inscription(Request $request)
    {
        $filieres = Filiere::actif()->ordre()->with(['niveaux' => function($query) {
            $query->where('statut', true);
        }])->get();
        $filiereId = $request->query('filiere');
        $niveauId = $request->query('niveau');
        $documentsRequis = DocumentRequis::actif()->ordre()->get();
        return view('front.inscription', compact('filieres', 'filiereId', 'niveauId', 'documentsRequis'));
    }

    public function inscriptionStore(Request $request)
    {
        $validated = $request->validate([
            'nom' => 'required|string|max:255',
            'prenom' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'telephone' => 'required|string|max:20',
            'filiere_id' => 'required|exists:filieres,id',
            'niveau_id' => 'required|exists:niveaux,id',
            'message' => 'nullable|string|max:1000',
        ]);

        Inscription::create($validated);

        return redirect()->route('inscription')->with('success', 'Votre inscription a été enregistrée avec succès. Nous vous contacterons prochainement.');
    }

    public function contact()
    {
        $faqs = Faq::actif()->ordre()->get();
        return view('front.contact', compact('faqs'));
    }

    public function contactStore(Request $request)
    {
        $validated = $request->validate([
            'nom' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'sujet' => 'required|string|max:255',
            'message' => 'required|string|max:2000',
        ]);

        Message::create($validated);

        return redirect()->route('contact')->with('success', 'Votre message a été envoyé avec succès. Nous vous répondrons dans les plus brefs délais.');
    }
}
