<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Filiere extends Model
{
    use HasFactory;

    protected $fillable = [
        'nom',
        'description',
        'statut',
        'ordre',
    ];

    protected $casts = [
        'statut' => 'boolean',
    ];

    public function niveaux()
    {
        return $this->hasMany(Niveau::class);
    }

    public function inscriptions()
    {
        return $this->hasMany(Inscription::class);
    }

    public function scopeActif($query)
    {
        return $query->where('statut', true);
    }

    public function scopeOrdre($query)
    {
        return $query->orderBy('ordre', 'asc');
    }
}
