<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Gallery extends Model
{
    use HasFactory;

    protected $table = 'galeries';

    protected $fillable = [
        'image_path',
        'titre',
        'description',
        'statut',
    ];

    protected $casts = [
        'statut' => 'boolean',
    ];

    /**
     * Scope pour récupérer uniquement les images actives
     */
    public function scopeActive($query)
    {
        return $query->where('statut', true);
    }
}
