<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Matiere extends Model
{
    use HasFactory;

    protected $fillable = [
        'niveau_id',
        'nom',
        'coefficient',
        'statut',
        'ordre',
    ];

    protected $casts = [
        'statut' => 'boolean',
    ];

    public function niveau()
    {
        return $this->belongsTo(Niveau::class);
    }

    public function scopeActif($query)
    {
        return $query->where('statut', true);
    }

    public function scopeOrdre($query)
    {
        return $query->orderBy('ordre', 'asc');
    }
}
