<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Niveau extends Model
{
    use HasFactory;

    protected $table = 'niveaux';

    protected $fillable = [
        'filiere_id',
        'nom',
        'statut',
    ];

    protected $casts = [
        'statut' => 'boolean',
    ];

    public function filiere()
    {
        return $this->belongsTo(Filiere::class);
    }

    public function matieres()
    {
        return $this->hasMany(Matiere::class);
    }

    public function frais()
    {
        return $this->hasOne(Frais::class);
    }

    public function documentsNiveau()
    {
        return $this->hasMany(DocumentNiveau::class);
    }

    public function inscriptions()
    {
        return $this->hasMany(Inscription::class);
    }

    public function scopeActif($query)
    {
        return $query->where('statut', true);
    }
}
