<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Supprimer d'abord la colonne programme_id de la table inscriptions
        Schema::table('inscriptions', function (Blueprint $table) {
            if (Schema::hasColumn('inscriptions', 'programme_id')) {
                $table->dropForeign(['programme_id']);
                $table->dropColumn('programme_id');
            }
        });

        // Ensuite supprimer la table programmes
        Schema::dropIfExists('programmes');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Recréer la table programmes
        Schema::create('programmes', function (Blueprint $table) {
            $table->id();
            $table->string('titre');
            $table->text('description')->nullable();
            $table->decimal('pension', 10, 2);
            $table->boolean('statut')->default(true);
            $table->timestamps();
        });

        // Remettre la colonne programme_id dans inscriptions
        Schema::table('inscriptions', function (Blueprint $table) {
            $table->foreignId('programme_id')->nullable()->after('telephone')->constrained('programmes')->onDelete('set null');
        });
    }
};
