@extends('layouts.admin')

@section('content')
<div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
    <div class="p-6 text-gray-900">
        <div class="mb-6">
            <h1 class="text-3xl font-bold">Modifier le Document Requis</h1>
            <p class="text-gray-500 mt-1">{{ $documentNiveau->niveau->filiere->nom }} - {{ $documentNiveau->niveau->nom }}</p>
        </div>

        <form action="{{ route('admin.documents-niveau.update', $documentNiveau) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="mb-4">
                <label for="intitule" class="block text-sm font-medium text-gray-700 mb-2">Intitule du document</label>
                <input type="text" name="intitule" id="intitule" value="{{ old('intitule', $documentNiveau->intitule) }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('intitule') border-red-500 @enderror">
                @error('intitule')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="description" class="block text-sm font-medium text-gray-700 mb-2">Description (optionnelle)</label>
                <textarea name="description" id="description" rows="2" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('description') border-red-500 @enderror">{{ old('description', $documentNiveau->description) }}</textarea>
                @error('description')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="ordre" class="block text-sm font-medium text-gray-700 mb-2">Ordre d'affichage</label>
                <input type="number" name="ordre" id="ordre" value="{{ old('ordre', $documentNiveau->ordre) }}" min="0" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('ordre') border-red-500 @enderror">
                @error('ordre')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-6">
                <label class="flex items-center">
                    <input type="hidden" name="obligatoire" value="0">
                    <input type="checkbox" name="obligatoire" value="1" {{ old('obligatoire', $documentNiveau->obligatoire) ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <span class="ml-2 text-sm text-gray-700">Document obligatoire</span>
                </label>
            </div>

            <div class="flex items-center justify-between">
                <a href="{{ route('admin.filieres.show', $documentNiveau->niveau->filiere_id) }}" class="text-gray-600 hover:text-gray-900">Annuler</a>
                <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded">
                    Mettre a jour
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
