@extends('layouts.admin')

@section('content')
<div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
    <div class="p-6 text-gray-900">
        <div class="mb-6">
            <h1 class="text-3xl font-bold">Modifier la FAQ</h1>
            <p class="text-gray-500 mt-1">{{ Str::limit($faq->question, 50) }}</p>
        </div>

        <form action="{{ route('admin.faqs.update', $faq) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="mb-4">
                <label for="question" class="block text-sm font-medium text-gray-700 mb-2">Question</label>
                <input type="text" name="question" id="question" value="{{ old('question', $faq->question) }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('question') border-red-500 @enderror">
                @error('question')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="reponse" class="block text-sm font-medium text-gray-700 mb-2">Reponse</label>
                <textarea name="reponse" id="reponse" rows="5" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('reponse') border-red-500 @enderror">{{ old('reponse', $faq->reponse) }}</textarea>
                @error('reponse')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="ordre" class="block text-sm font-medium text-gray-700 mb-2">Ordre d'affichage</label>
                <input type="number" name="ordre" id="ordre" value="{{ old('ordre', $faq->ordre) }}" min="0" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('ordre') border-red-500 @enderror">
                @error('ordre')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-6">
                <label class="flex items-center">
                    <input type="hidden" name="actif" value="0">
                    <input type="checkbox" name="actif" value="1" {{ old('actif', $faq->actif) ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <span class="ml-2 text-sm text-gray-700">FAQ active (visible sur le site)</span>
                </label>
            </div>

            <div class="flex items-center justify-between">
                <a href="{{ route('admin.faqs.index') }}" class="text-gray-600 hover:text-gray-900">Annuler</a>
                <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded">
                    Mettre a jour
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
