@extends('layouts.admin')

@section('content')
<div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
    <div class="p-6 text-gray-900">
        <div class="mb-6">
            <h1 class="text-3xl font-bold">Configurer les Frais</h1>
            <p class="text-gray-500 mt-1">{{ $niveau->filiere->nom }} - {{ $niveau->nom }}</p>
        </div>

        <form action="{{ route('admin.frais.update', $niveau) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="mb-4">
                <label for="montant_total" class="block text-sm font-medium text-gray-700 mb-2">Montant total annuel (FCFA) *</label>
                <input type="number" name="montant_total" id="montant_total" value="{{ old('montant_total', $frais->montant_total ?? 0) }}" min="0" step="0.01" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('montant_total') border-red-500 @enderror">
                @error('montant_total')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="frais_inscription" class="block text-sm font-medium text-gray-700 mb-2">Frais d'inscription (FCFA)</label>
                <input type="number" name="frais_inscription" id="frais_inscription" value="{{ old('frais_inscription', $frais->frais_inscription ?? 0) }}" min="0" step="0.01" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('frais_inscription') border-red-500 @enderror">
                @error('frais_inscription')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <div class="border-t pt-4 mt-4">
                <h3 class="text-lg font-semibold text-gray-700 mb-4">Paiement par tranches (optionnel)</h3>

                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <label for="tranche_1" class="block text-sm font-medium text-gray-700 mb-2">Tranche 1 (FCFA)</label>
                        <input type="number" name="tranche_1" id="tranche_1" value="{{ old('tranche_1', $frais->tranche_1) }}" min="0" step="0.01" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>

                    <div>
                        <label for="tranche_2" class="block text-sm font-medium text-gray-700 mb-2">Tranche 2 (FCFA)</label>
                        <input type="number" name="tranche_2" id="tranche_2" value="{{ old('tranche_2', $frais->tranche_2) }}" min="0" step="0.01" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>

                    <div>
                        <label for="tranche_3" class="block text-sm font-medium text-gray-700 mb-2">Tranche 3 (FCFA)</label>
                        <input type="number" name="tranche_3" id="tranche_3" value="{{ old('tranche_3', $frais->tranche_3) }}" min="0" step="0.01" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                </div>
            </div>

            <div class="flex items-center justify-between mt-6">
                <a href="{{ route('admin.filieres.show', $niveau->filiere_id) }}" class="text-gray-600 hover:text-gray-900">Annuler</a>
                <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded">
                    Enregistrer les frais
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
