@extends('layouts.admin')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="flex items-center gap-4">
        <a href="{{ route('admin.galerie.index') }}" class="p-2 hover:bg-gray-100 rounded-lg transition">
            <svg class="w-5 h-5 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
            </svg>
        </a>
        <div>
            <h2 class="text-2xl font-bold text-gray-900">Modifier l'image</h2>
            <p class="text-sm text-gray-600 mt-1">Modifiez les informations de l'image</p>
        </div>
    </div>

    <!-- Formulaire -->
    <div class="bg-white rounded-lg shadow-sm border border-gray-200">
        <form action="{{ route('admin.galerie.update', $galerie->id) }}" method="POST" enctype="multipart/form-data" class="p-6 space-y-6">
            @csrf
            @method('PUT')

            <!-- Image actuelle -->
            <div>
                <label class="block text-sm font-semibold text-gray-900 mb-2">Image actuelle</label>
                <div class="w-64 h-64 bg-gray-100 rounded-lg overflow-hidden border border-gray-200">
                    <img src="{{ asset('storage/' . $galerie->image_path) }}" alt="{{ $galerie->titre }}" class="w-full h-full object-cover">
                </div>
            </div>

            <!-- Nouvelle image -->
            <div>
                <label class="block text-sm font-semibold text-gray-900 mb-2">Remplacer l'image (optionnel)</label>
                <input type="file" name="image" accept="image/*" class="w-full px-4 py-2.5 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('image') border-red-500 @enderror">
                @error('image')
                    <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                @enderror
                <p class="text-xs text-gray-500 mt-1">Formats acceptés : JPEG, PNG, JPG, GIF. Taille max : 5 Mo</p>
            </div>

            <!-- Titre -->
            <div>
                <label class="block text-sm font-semibold text-gray-900 mb-2">Titre (optionnel)</label>
                <input type="text" name="titre" value="{{ old('titre', $galerie->titre) }}" maxlength="255" class="w-full px-4 py-2.5 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('titre') border-red-500 @enderror">
                @error('titre')
                    <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Description -->
            <div>
                <label class="block text-sm font-semibold text-gray-900 mb-2">Description (optionnelle)</label>
                <textarea name="description" rows="4" class="w-full px-4 py-2.5 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('description') border-red-500 @enderror">{{ old('description', $galerie->description) }}</textarea>
                @error('description')
                    <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Statut -->
            <div>
                <label class="flex items-center gap-3 cursor-pointer">
                    <input type="checkbox" name="statut" value="1" {{ old('statut', $galerie->statut) ? 'checked' : '' }} class="w-5 h-5 text-blue-600 border-gray-300 rounded focus:ring-2 focus:ring-blue-500">
                    <div>
                        <span class="text-sm font-semibold text-gray-900">Image visible</span>
                        <p class="text-xs text-gray-500">L'image sera affichée sur la page Galerie</p>
                    </div>
                </label>
            </div>

            <!-- Actions -->
            <div class="flex items-center gap-3 pt-4 border-t">
                <button type="submit" class="px-6 py-2.5 bg-blue-600 text-white font-medium rounded-lg hover:bg-blue-700 transition">
                    Enregistrer les modifications
                </button>
                <a href="{{ route('admin.galerie.index') }}" class="px-6 py-2.5 bg-gray-100 text-gray-700 font-medium rounded-lg hover:bg-gray-200 transition">
                    Annuler
                </a>
            </div>
        </form>
    </div>
</div>
@endsection
