@extends('layouts.admin')

@section('content')
<div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
    <div class="p-6 text-gray-900">
        <div class="mb-6">
            <h1 class="text-3xl font-bold">Ajouter une Matiere</h1>
            <p class="text-gray-500 mt-1">{{ $niveau->filiere->nom }} - {{ $niveau->nom }}</p>
        </div>

        <form action="{{ route('admin.matieres.store', $niveau) }}" method="POST">
            @csrf

            <div class="mb-4">
                <label for="nom" class="block text-sm font-medium text-gray-700 mb-2">Nom de la matiere</label>
                <input type="text" name="nom" id="nom" value="{{ old('nom') }}" placeholder="Ex: Comptabilite generale" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('nom') border-red-500 @enderror">
                @error('nom')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="coefficient" class="block text-sm font-medium text-gray-700 mb-2">Coefficient</label>
                <input type="number" name="coefficient" id="coefficient" value="{{ old('coefficient', 1) }}" min="1" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('coefficient') border-red-500 @enderror">
                @error('coefficient')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="ordre" class="block text-sm font-medium text-gray-700 mb-2">Ordre d'affichage</label>
                <input type="number" name="ordre" id="ordre" value="{{ old('ordre', 0) }}" min="0" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('ordre') border-red-500 @enderror">
                @error('ordre')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-6">
                <label class="flex items-center">
                    <input type="hidden" name="statut" value="0">
                    <input type="checkbox" name="statut" value="1" {{ old('statut', true) ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <span class="ml-2 text-sm text-gray-700">Matiere active</span>
                </label>
            </div>

            <div class="flex items-center justify-between">
                <a href="{{ route('admin.filieres.show', $niveau->filiere_id) }}" class="text-gray-600 hover:text-gray-900">Annuler</a>
                <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded">
                    Ajouter la matiere
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
