@extends('layouts.admin')

@section('content')
<div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
    <div class="p-6 text-gray-900">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-3xl font-bold">Detail du message</h1>
            <a href="{{ route('admin.messages.index') }}" class="text-indigo-600 hover:text-indigo-900">
                Retour a la liste
            </a>
        </div>

        @if(session('success'))
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                {{ session('success') }}
            </div>
        @endif

        @if(session('error'))
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                {{ session('error') }}
            </div>
        @endif

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
            <div class="bg-gray-50 p-4 rounded-lg">
                <h2 class="text-lg font-semibold mb-4">Informations expediteur</h2>
                <dl class="space-y-2">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Nom</dt>
                        <dd class="text-sm text-gray-900">{{ $message->nom }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Email</dt>
                        <dd class="text-sm text-gray-900">{{ $message->email }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Date</dt>
                        <dd class="text-sm text-gray-900">{{ $message->created_at->format('d/m/Y a H:i') }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Statut</dt>
                        <dd class="text-sm">
                            @if(!$message->lu)
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800">Non lu</span>
                            @else
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-100 text-gray-800">Lu</span>
                            @endif
                        </dd>
                    </div>
                </dl>
            </div>

            <div class="bg-gray-50 p-4 rounded-lg">
                <h2 class="text-lg font-semibold mb-4">Sujet</h2>
                <p class="text-sm text-gray-900">{{ $message->sujet }}</p>
            </div>
        </div>

        <div class="bg-gray-50 p-4 rounded-lg mb-6">
            <h2 class="text-lg font-semibold mb-2">Message</h2>
            <p class="text-sm text-gray-900 whitespace-pre-wrap">{{ $message->message }}</p>
        </div>

        <div class="bg-gray-50 p-4 rounded-lg">
            <h2 class="text-lg font-semibold mb-4">Repondre</h2>

            @if(!$mailEnabled)
                <div class="bg-yellow-100 border border-yellow-400 text-yellow-700 px-4 py-3 rounded mb-4">
                    L'envoi d'emails est desactive. <a href="{{ route('admin.settings.email') }}" class="underline font-semibold">Configurer les parametres email</a>
                </div>
            @endif

            <form action="{{ route('admin.messages.repondre', $message) }}" method="POST">
                @csrf
                <div class="mb-4">
                    <label for="reponse" class="block text-sm font-medium text-gray-700 mb-1">Votre reponse</label>
                    <textarea name="reponse" id="reponse" rows="5" required {{ !$mailEnabled ? 'disabled' : '' }}
                        class="w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('reponse') border-red-500 @enderror {{ !$mailEnabled ? 'bg-gray-100' : '' }}">{{ old('reponse') }}</textarea>
                    @error('reponse')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>
                <button type="submit" {{ !$mailEnabled ? 'disabled' : '' }}
                    class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded transition {{ !$mailEnabled ? 'opacity-50 cursor-not-allowed' : '' }}">
                    Envoyer la reponse
                </button>
            </form>
        </div>
    </div>
</div>
@endsection
