@extends('layouts.front')

@section('content')
<!-- Page Header -->
<section class="bg-gradient-to-r from-blue-900 to-blue-800 py-16">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center">
            <h1 class="text-4xl sm:text-5xl font-bold text-white mb-4">Galerie</h1>
            <p class="text-lg text-blue-100 max-w-2xl mx-auto">
                Découvrez les activités et événements du campus ISTMAD
            </p>
        </div>
    </div>
</section>

<!-- Galerie d'images -->
<section class="py-20 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        @if($images->isEmpty())
            <div class="bg-slate-50 rounded-2xl p-12 text-center">
                <div class="w-20 h-20 bg-slate-200 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-10 h-10 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                    </svg>
                </div>
                <h3 class="text-2xl font-bold text-slate-900 mb-2">Aucune image disponible</h3>
                <p class="text-slate-600">La galerie sera bientôt mise à jour avec de nouvelles photos</p>
            </div>
        @else
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
                @foreach($images as $image)
                    <div class="group cursor-pointer" onclick="openLightbox({{ $loop->index }})">
                        <div class="aspect-square overflow-hidden rounded-xl bg-slate-100 shadow-md hover:shadow-xl transition-all duration-300">
                            <img
                                src="{{ asset('storage/' . $image->image_path) }}"
                                alt="{{ $image->titre ?? 'Image ISTMAD' }}"
                                class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-300"
                            >
                        </div>
                        @if($image->titre)
                            <h3 class="mt-3 text-sm font-semibold text-slate-900 group-hover:text-blue-600 transition">
                                {{ $image->titre }}
                            </h3>
                        @endif
                        @if($image->description)
                            <p class="mt-1 text-xs text-slate-600 line-clamp-2">
                                {{ $image->description }}
                            </p>
                        @endif
                    </div>
                @endforeach
            </div>
        @endif
    </div>
</section>

<!-- Lightbox Modal -->
@if($images->isNotEmpty())
<div id="lightbox" class="fixed inset-0 bg-black/95 z-50 hidden flex items-center justify-center">
    <button onclick="closeLightbox()" class="absolute top-6 right-6 text-white hover:text-gray-300 transition z-10">
        <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
        </svg>
    </button>

    <button onclick="previousImage()" class="absolute left-6 text-white hover:text-gray-300 transition z-10">
        <svg class="w-12 h-12" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
        </svg>
    </button>

    <button onclick="nextImage()" class="absolute right-6 text-white hover:text-gray-300 transition z-10">
        <svg class="w-12 h-12" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
        </svg>
    </button>

    <div class="max-w-5xl max-h-[90vh] mx-auto px-4">
        <img id="lightbox-image" src="" alt="" class="max-w-full max-h-[80vh] object-contain mx-auto">
        <div id="lightbox-info" class="text-center mt-6 text-white"></div>
    </div>
</div>

<script>
let currentImageIndex = 0;
const images = @json($images->map(function($img) {
    return [
        'path' => asset('storage/' . $img->image_path),
        'titre' => $img->titre,
        'description' => $img->description
    ];
}));

function openLightbox(index) {
    currentImageIndex = index;
    updateLightboxImage();
    document.getElementById('lightbox').classList.remove('hidden');
    document.body.style.overflow = 'hidden';
}

function closeLightbox() {
    document.getElementById('lightbox').classList.add('hidden');
    document.body.style.overflow = 'auto';
}

function nextImage() {
    currentImageIndex = (currentImageIndex + 1) % images.length;
    updateLightboxImage();
}

function previousImage() {
    currentImageIndex = (currentImageIndex - 1 + images.length) % images.length;
    updateLightboxImage();
}

function updateLightboxImage() {
    const image = images[currentImageIndex];
    document.getElementById('lightbox-image').src = image.path;

    let infoHtml = '';
    if (image.titre) {
        infoHtml += `<h3 class="text-xl font-bold mb-2">${image.titre}</h3>`;
    }
    if (image.description) {
        infoHtml += `<p class="text-gray-300">${image.description}</p>`;
    }
    document.getElementById('lightbox-info').innerHTML = infoHtml;
}

// Fermer avec Escape
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') closeLightbox();
    if (e.key === 'ArrowRight') nextImage();
    if (e.key === 'ArrowLeft') previousImage();
});

// Fermer en cliquant sur le fond
document.getElementById('lightbox').addEventListener('click', function(e) {
    if (e.target === this) closeLightbox();
});
</script>
@endif
@endsection
