@extends('layouts.front')

@section('content')
<!-- Page Header -->
<section class="bg-gradient-to-r from-blue-900 to-blue-800 py-16">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center">
            <h1 class="text-4xl sm:text-5xl font-bold text-white mb-4">Inscription</h1>
            <p class="text-lg text-blue-100 max-w-2xl mx-auto">
                Rejoignez ISTMAD et construisez votre avenir professionnel
            </p>
        </div>
    </div>
</section>

<!-- Inscription Form Section -->
<section class="py-16 bg-slate-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid lg:grid-cols-3 gap-8">
            <!-- Form Column -->
            <div class="lg:col-span-2">
                <div class="bg-white rounded-2xl shadow-sm p-8">
                    <div class="mb-8">
                        <h2 class="text-2xl font-bold text-slate-900 mb-2">Formulaire d'inscription</h2>
                        <p class="text-slate-600">Remplissez ce formulaire pour démarrer votre inscription. Notre équipe vous contactera dans les plus brefs délais.</p>
                    </div>

                    @if(session('success'))
                        <div class="bg-green-50 border border-green-200 rounded-xl p-4 mb-6 flex items-start gap-3">
                            <div class="flex-shrink-0">
                                <svg class="w-6 h-6 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                            </div>
                            <div>
                                <h3 class="font-semibold text-green-800">Inscription envoyée avec succès !</h3>
                                <p class="text-green-700 text-sm mt-1">{{ session('success') }}</p>
                            </div>
                        </div>
                    @endif

                    <form method="POST" action="{{ route('inscription.store') }}" class="space-y-6">
                        @csrf

                        <!-- Informations personnelles -->
                        <div>
                            <h3 class="text-lg font-semibold text-slate-900 mb-4 flex items-center gap-2">
                                <span class="w-8 h-8 bg-blue-100 text-blue-600 rounded-full flex items-center justify-center text-sm font-bold">1</span>
                                Informations personnelles
                            </h3>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label for="nom" class="block text-sm font-medium text-slate-700 mb-2">Nom <span class="text-red-500">*</span></label>
                                    <input type="text" name="nom" id="nom" value="{{ old('nom') }}" required
                                        class="w-full px-4 py-3 border border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20 transition @error('nom') border-red-500 @enderror"
                                        placeholder="Votre nom de famille">
                                    @error('nom')
                                        <p class="mt-2 text-sm text-red-600 flex items-center gap-1">
                                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                                            {{ $message }}
                                        </p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="prenom" class="block text-sm font-medium text-slate-700 mb-2">Prénom <span class="text-red-500">*</span></label>
                                    <input type="text" name="prenom" id="prenom" value="{{ old('prenom') }}" required
                                        class="w-full px-4 py-3 border border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20 transition @error('prenom') border-red-500 @enderror"
                                        placeholder="Votre prénom">
                                    @error('prenom')
                                        <p class="mt-2 text-sm text-red-600 flex items-center gap-1">
                                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                                            {{ $message }}
                                        </p>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Coordonnees -->
                        <div>
                            <h3 class="text-lg font-semibold text-slate-900 mb-4 flex items-center gap-2">
                                <span class="w-8 h-8 bg-blue-100 text-blue-600 rounded-full flex items-center justify-center text-sm font-bold">2</span>
                                Coordonnées
                            </h3>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label for="email" class="block text-sm font-medium text-slate-700 mb-2">Email <span class="text-red-500">*</span></label>
                                    <input type="email" name="email" id="email" value="{{ old('email') }}" required
                                        class="w-full px-4 py-3 border border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20 transition @error('email') border-red-500 @enderror"
                                        placeholder="votre@email.com">
                                    @error('email')
                                        <p class="mt-2 text-sm text-red-600 flex items-center gap-1">
                                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                                            {{ $message }}
                                        </p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="telephone" class="block text-sm font-medium text-slate-700 mb-2">Téléphone <span class="text-red-500">*</span></label>
                                    <input type="text" name="telephone" id="telephone" value="{{ old('telephone') }}" required
                                        class="w-full px-4 py-3 border border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20 transition @error('telephone') border-red-500 @enderror"
                                        placeholder="6XX XXX XXX">
                                    @error('telephone')
                                        <p class="mt-2 text-sm text-red-600 flex items-center gap-1">
                                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                                            {{ $message }}
                                        </p>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Choix de la filiere et niveau -->
                        <div>
                            <h3 class="text-lg font-semibold text-slate-900 mb-4 flex items-center gap-2">
                                <span class="w-8 h-8 bg-blue-100 text-blue-600 rounded-full flex items-center justify-center text-sm font-bold">3</span>
                                Choix de la filière
                            </h3>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label for="filiere_id" class="block text-sm font-medium text-slate-700 mb-2">Filière souhaitée <span class="text-red-500">*</span></label>
                                    <select name="filiere_id" id="filiere_id" required
                                        class="w-full px-4 py-3 border border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20 transition @error('filiere_id') border-red-500 @enderror">
                                        <option value="">-- Sélectionnez une filière --</option>
                                        @foreach($filieres as $filiere)
                                            <option value="{{ $filiere->id }}" data-niveaux="{{ json_encode($filiere->niveaux->map(function($n) { return ['id' => $n->id, 'nom' => $n->nom]; })) }}" {{ (old('filiere_id', $filiereId) == $filiere->id) ? 'selected' : '' }}>
                                                {{ $filiere->nom }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('filiere_id')
                                        <p class="mt-2 text-sm text-red-600 flex items-center gap-1">
                                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                                            {{ $message }}
                                        </p>
                                    @enderror
                                </div>
                                <div>
                                    <label for="niveau_id" class="block text-sm font-medium text-slate-700 mb-2">Niveau <span class="text-red-500">*</span></label>
                                    <select name="niveau_id" id="niveau_id" required
                                        class="w-full px-4 py-3 border border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20 transition @error('niveau_id') border-red-500 @enderror">
                                        <option value="">-- Sélectionnez d'abord une filière --</option>
                                    </select>
                                    @error('niveau_id')
                                        <p class="mt-2 text-sm text-red-600 flex items-center gap-1">
                                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                                            {{ $message }}
                                        </p>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Message optionnel -->
                        <div>
                            <h3 class="text-lg font-semibold text-slate-900 mb-4 flex items-center gap-2">
                                <span class="w-8 h-8 bg-slate-100 text-slate-600 rounded-full flex items-center justify-center text-sm font-bold">4</span>
                                Message (optionnel)
                            </h3>
                            <div>
                                <label for="message" class="block text-sm font-medium text-slate-700 mb-2">Votre message</label>
                                <textarea name="message" id="message" rows="4"
                                    class="w-full px-4 py-3 border border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20 transition resize-none @error('message') border-red-500 @enderror"
                                    placeholder="Parlez-nous de votre parcours, vos motivations...">{{ old('message') }}</textarea>
                                @error('message')
                                    <p class="mt-2 text-sm text-red-600 flex items-center gap-1">
                                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                                        {{ $message }}
                                    </p>
                                @enderror
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <div class="pt-4">
                            <button type="submit" class="w-full bg-blue-900 hover:bg-blue-800 text-white font-semibold py-4 px-6 rounded-xl transition flex items-center justify-center gap-2 group">
                                <span>Envoyer mon inscription</span>
                                <svg class="w-5 h-5 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"/>
                                </svg>
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="lg:col-span-1 space-y-6">
                <!-- Info Card -->
                <div class="bg-white rounded-2xl shadow-sm p-6">
                    <h3 class="text-lg font-bold text-slate-900 mb-4">Processus d'inscription</h3>
                    <div class="space-y-4">
                        <div class="flex items-start gap-3">
                            <div class="w-8 h-8 bg-blue-100 text-blue-600 rounded-full flex items-center justify-center text-sm font-bold flex-shrink-0">1</div>
                            <div>
                                <h4 class="font-semibold text-slate-900">Remplir le formulaire</h4>
                                <p class="text-sm text-slate-600">Complétez vos informations personnelles</p>
                            </div>
                        </div>
                        <div class="flex items-start gap-3">
                            <div class="w-8 h-8 bg-blue-100 text-blue-600 rounded-full flex items-center justify-center text-sm font-bold flex-shrink-0">2</div>
                            <div>
                                <h4 class="font-semibold text-slate-900">Confirmation</h4>
                                <p class="text-sm text-slate-600">Notre équipe examine votre demande</p>
                            </div>
                        </div>
                        <div class="flex items-start gap-3">
                            <div class="w-8 h-8 bg-blue-100 text-blue-600 rounded-full flex items-center justify-center text-sm font-bold flex-shrink-0">3</div>
                            <div>
                                <h4 class="font-semibold text-slate-900">Contact</h4>
                                <p class="text-sm text-slate-600">Nous vous contactons pour finaliser</p>
                            </div>
                        </div>
                        <div class="flex items-start gap-3">
                            <div class="w-8 h-8 bg-green-100 text-green-600 rounded-full flex items-center justify-center text-sm font-bold flex-shrink-0">4</div>
                            <div>
                                <h4 class="font-semibold text-slate-900">Inscription validée</h4>
                                <p class="text-sm text-slate-600">Bienvenue à ISTMAD !</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Contact Card -->
                <div class="bg-gradient-to-br from-blue-900 to-blue-800 rounded-2xl shadow-sm p-6 text-white">
                    <h3 class="text-lg font-bold mb-4">Besoin d'aide ?</h3>
                    <p class="text-blue-100 text-sm mb-4">Notre équipe est disponible pour répondre à toutes vos questions concernant l'inscription.</p>
                    <div class="space-y-3">
                        <a href="tel:+237675658165" class="flex items-center gap-3 text-blue-100 hover:text-white transition">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
                            </svg>
                            <span>+237 675 65 81 65</span>
                        </a>
                        <a href="mailto:infos@istmad.com" class="flex items-center gap-3 text-blue-100 hover:text-white transition">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                            </svg>
                            <span>infos@istmad.com</span>
                        </a>
                    </div>
                </div>

                <!-- Documents Card -->
                @if($documentsRequis->count() > 0)
                <div class="bg-white rounded-2xl shadow-sm p-6">
                    <h3 class="text-lg font-bold text-slate-900 mb-4">Documents requis</h3>
                    <ul class="space-y-3">
                        @foreach($documentsRequis as $document)
                        <li class="flex items-start gap-2 text-sm text-slate-600">
                            <svg class="w-5 h-5 text-green-500 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            <div>
                                <span>{{ $document->intitule }}</span>
                                @if($document->description)
                                    <p class="text-xs text-slate-500 mt-0.5">{{ $document->description }}</p>
                                @endif
                            </div>
                        </li>
                        @endforeach
                    </ul>
                </div>
                @endif
            </div>
        </div>
    </div>
</section>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const filiereSelect = document.getElementById('filiere_id');
    const niveauSelect = document.getElementById('niveau_id');
    const preselectedNiveau = "{{ $niveauId ?? '' }}";

    function updateNiveaux() {
        const selectedOption = filiereSelect.options[filiereSelect.selectedIndex];
        const niveauxData = selectedOption.dataset.niveaux;

        niveauSelect.innerHTML = '<option value="">-- Sélectionnez un niveau --</option>';

        if (niveauxData) {
            const niveaux = JSON.parse(niveauxData);
            niveaux.forEach(function(niveau) {
                const option = document.createElement('option');
                option.value = niveau.id;
                option.textContent = niveau.nom;
                if (preselectedNiveau && niveau.id == preselectedNiveau) {
                    option.selected = true;
                }
                niveauSelect.appendChild(option);
            });
        }
    }

    filiereSelect.addEventListener('change', updateNiveaux);

    // Initialize on page load if filiere is preselected
    if (filiereSelect.value) {
        updateNiveaux();
    }
});
</script>
@endsection
