<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Header -->
    <div class="flex items-center justify-between">
        <div>
            <h2 class="text-2xl font-bold text-gray-900">Gestion de la Galerie</h2>
            <p class="text-sm text-gray-600 mt-1">Gérez les images affichées sur la page Galerie</p>
        </div>
        <a href="<?php echo e(route('admin.galerie.create')); ?>" class="px-5 py-2.5 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition flex items-center gap-2">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
            </svg>
            Ajouter une image
        </a>
    </div>

    <!-- Messages de succès -->
    <?php if(session('success')): ?>
        <div class="bg-green-50 border border-green-200 text-green-800 px-4 py-3 rounded-lg">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <!-- Liste des images -->
    <?php if($images->isEmpty()): ?>
        <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-12 text-center">
            <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
                <svg class="w-8 h-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                </svg>
            </div>
            <h3 class="text-lg font-semibold text-gray-900 mb-2">Aucune image</h3>
            <p class="text-gray-600 mb-6">Commencez par ajouter des images à la galerie</p>
            <a href="<?php echo e(route('admin.galerie.create')); ?>" class="inline-flex items-center gap-2 px-5 py-2.5 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
                </svg>
                Ajouter une image
            </a>
        </div>
    <?php else: ?>
        <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4 p-6">
                <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="group relative bg-gray-50 rounded-lg overflow-hidden border border-gray-200 hover:shadow-lg transition">
                        <!-- Image -->
                        <div class="aspect-square overflow-hidden bg-gray-100">
                            <img src="<?php echo e(asset('storage/' . $image->image_path)); ?>" alt="<?php echo e($image->titre); ?>" class="w-full h-full object-cover group-hover:scale-105 transition duration-300">
                        </div>

                        <!-- Informations -->
                        <div class="p-4">
                            <div class="flex items-center justify-between mb-2">
                                <span class="inline-flex items-center px-2.5 py-1 rounded-full text-xs font-medium <?php echo e($image->statut ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800'); ?>">
                                    <?php echo e($image->statut ? 'Visible' : 'Masquée'); ?>

                                </span>
                            </div>

                            <?php if($image->titre): ?>
                                <h3 class="font-semibold text-gray-900 text-sm mb-1 truncate"><?php echo e($image->titre); ?></h3>
                            <?php endif; ?>

                            <?php if($image->description): ?>
                                <p class="text-xs text-gray-600 line-clamp-2 mb-3"><?php echo e($image->description); ?></p>
                            <?php endif; ?>

                            <!-- Actions -->
                            <div class="flex items-center gap-2 mt-3">
                                <a href="<?php echo e(route('admin.galerie.edit', $image->id)); ?>" class="flex-1 px-3 py-2 bg-blue-50 text-blue-600 text-xs font-medium rounded hover:bg-blue-100 transition text-center">
                                    Modifier
                                </a>
                                <form action="<?php echo e(route('admin.galerie.destroy', $image->id)); ?>" method="POST" onsubmit="return confirm('Confirmer la suppression ?')" class="flex-1">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="w-full px-3 py-2 bg-red-50 text-red-600 text-xs font-medium rounded hover:bg-red-100 transition">
                                        Supprimer
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\istmat\resources\views/admin/galerie/index.blade.php ENDPATH**/ ?>