<?php $__env->startSection('content'); ?>
<!-- Page Header -->
<section class="bg-blue-900 py-16">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center">
            <h1 class="text-4xl sm:text-5xl font-bold text-white mb-4">Nos Filières BTS / HND</h1>
            <p class="text-lg text-white/90 max-w-2xl mx-auto">
                Des formations professionnelles reconnues pour votre réussite
            </p>
        </div>
    </div>
</section>

<!-- Introduction -->
<section class="py-12 bg-white border-b">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex flex-col md:flex-row items-center justify-between gap-6">
            <div>
                <h2 class="text-2xl font-bold text-slate-900 mb-2">Formations diplômantes en 2 ans</h2>
                <p class="text-slate-600">Tous nos programmes sont agréés par le Ministère de l'Enseignement Supérieur</p>
            </div>
            <div class="flex items-center gap-6 text-center">
                <div>
                    <div class="text-3xl font-bold text-sky-600">2 ans</div>
                    <div class="text-sm text-slate-600">de formation</div>
                </div>
                <div class="h-12 w-px bg-slate-200"></div>
                <div>
                    <div class="text-3xl font-bold text-sky-600">BTS</div>
                    <div class="text-sm text-slate-600">Diplôme d'État</div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Filieres List -->
<section class="py-16 bg-slate-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <?php if($filieres->isEmpty()): ?>
            <div class="bg-white rounded-2xl p-12 text-center shadow-sm">
                <div class="w-16 h-16 bg-slate-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-slate-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-slate-900 mb-2">Aucune filière disponible</h3>
                <p class="text-slate-600">Les filières seront bientôt disponibles. Revenez nous voir prochainement.</p>
            </div>
        <?php else: ?>
            <div class="space-y-16">
                <?php $__currentLoopData = $filieres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $filiere): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <!-- Filiere Container -->
                    <div class="bg-white rounded-3xl shadow-lg overflow-hidden border border-slate-200">

                        <!-- Filiere Header - Description globale -->
                        <div class="bg-blue-900 p-8 lg:p-10">
                            <div class="max-w-4xl">
                                <div class="flex items-center gap-3 mb-4">
                                    <span class="px-4 py-1.5 bg-white/20 backdrop-blur-sm text-white text-sm font-semibold rounded-full border border-white/30">BTS - Formation en 2 ans</span>
                                </div>
                                <h2 class="text-3xl lg:text-4xl font-bold text-white mb-4"><?php echo e($filiere->nom); ?></h2>
                                <?php if($filiere->description): ?>
                                    <p class="text-white/90 text-lg leading-relaxed"><?php echo e($filiere->description); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Parcours academique - Niveaux -->
                        <?php if($filiere->niveaux->count() > 0): ?>
                            <div class="p-8 lg:p-10 bg-gradient-to-b from-slate-50 to-white">
                                <div class="mb-8 text-center">
                                    <h3 class="text-2xl font-bold text-slate-900 mb-2">Parcours de formation</h3>
                                    <p class="text-slate-600">Découvrez le contenu de chaque année d'études</p>
                                </div>

                                <div class="grid lg:grid-cols-2 gap-8">
                                    <?php $__currentLoopData = $filiere->niveaux; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $niveau): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <!-- Niveau Card -->
                                        <div class="relative bg-white rounded-2xl shadow-md border-2 <?php echo e($index === 0 ? 'border-emerald-200' : 'border-amber-200'); ?> overflow-hidden hover:shadow-xl transition-all duration-300">

                                            <!-- Niveau Header avec badge -->
                                            <div class="relative bg-gradient-to-r <?php echo e($index === 0 ? 'from-emerald-500 to-emerald-600' : 'from-amber-500 to-amber-600'); ?> p-6">
                                                <div class="absolute top-4 right-4">
                                                    <div class="w-12 h-12 bg-white/20 backdrop-blur-sm rounded-full flex items-center justify-center border-2 border-white/40">
                                                        <span class="text-white font-bold text-lg"><?php echo e($index + 1); ?></span>
                                                    </div>
                                                </div>
                                                <h4 class="text-2xl font-bold text-white mb-2"><?php echo e($niveau->nom); ?></h4>
                                                <p class="text-white/90 text-sm"><?php echo e($index === 0 ? 'Première année - Fondamentaux' : 'Deuxième année - Spécialisation'); ?></p>
                                            </div>

                                            <div class="p-6 space-y-6">

                                                <!-- Section Frais - Plus visible -->
                                                <?php if($niveau->frais): ?>
                                                    <div class="bg-gradient-to-br <?php echo e($index === 0 ? 'from-emerald-50 to-emerald-100/50' : 'from-amber-50 to-amber-100/50'); ?> rounded-xl p-5 border <?php echo e($index === 0 ? 'border-emerald-200' : 'border-amber-200'); ?>">
                                                        <div class="flex items-center justify-between mb-4">
                                                            <div class="flex items-center gap-2">
                                                                <svg class="w-5 h-5 <?php echo e($index === 0 ? 'text-emerald-600' : 'text-amber-600'); ?>" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                                                </svg>
                                                                <h5 class="font-bold <?php echo e($index === 0 ? 'text-emerald-900' : 'text-amber-900'); ?> text-base">Frais de scolarité</h5>
                                                            </div>
                                                            <div class="text-right">
                                                                <div class="text-2xl font-bold <?php echo e($index === 0 ? 'text-emerald-900' : 'text-amber-900'); ?>"><?php echo e(number_format($niveau->frais->montant_total, 0, ',', ' ')); ?></div>
                                                                <div class="text-xs <?php echo e($index === 0 ? 'text-emerald-700' : 'text-amber-700'); ?> font-medium">FCFA/an</div>
                                                            </div>
                                                        </div>

                                                        <?php if($niveau->frais->tranche_1 || $niveau->frais->tranche_2 || $niveau->frais->tranche_3): ?>
                                                            <div class="space-y-2">
                                                                <div class="text-xs font-semibold <?php echo e($index === 0 ? 'text-emerald-800' : 'text-amber-800'); ?> uppercase tracking-wider mb-2">Paiement échelonné possible</div>
                                                                <div class="grid grid-cols-3 gap-2">
                                                                    <?php if($niveau->frais->tranche_1): ?>
                                                                        <div class="bg-white rounded-lg p-3 text-center shadow-sm">
                                                                            <div class="text-xs text-slate-600 mb-1">Tranche 1</div>
                                                                            <div class="font-bold text-slate-900 text-sm"><?php echo e(number_format($niveau->frais->tranche_1, 0, ',', ' ')); ?></div>
                                                                        </div>
                                                                    <?php endif; ?>
                                                                    <?php if($niveau->frais->tranche_2): ?>
                                                                        <div class="bg-white rounded-lg p-3 text-center shadow-sm">
                                                                            <div class="text-xs text-slate-600 mb-1">Tranche 2</div>
                                                                            <div class="font-bold text-slate-900 text-sm"><?php echo e(number_format($niveau->frais->tranche_2, 0, ',', ' ')); ?></div>
                                                                        </div>
                                                                    <?php endif; ?>
                                                                    <?php if($niveau->frais->tranche_3): ?>
                                                                        <div class="bg-white rounded-lg p-3 text-center shadow-sm">
                                                                            <div class="text-xs text-slate-600 mb-1">Tranche 3</div>
                                                                            <div class="font-bold text-slate-900 text-sm"><?php echo e(number_format($niveau->frais->tranche_3, 0, ',', ' ')); ?></div>
                                                                        </div>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        <?php endif; ?>

                                                        <?php if($niveau->frais->frais_inscription > 0): ?>
                                                            <div class="mt-3 pt-3 border-t <?php echo e($index === 0 ? 'border-emerald-200' : 'border-amber-200'); ?>">
                                                                <div class="flex items-center justify-between text-xs">
                                                                    <span class="<?php echo e($index === 0 ? 'text-emerald-700' : 'text-amber-700'); ?>">Frais d'inscription</span>
                                                                    <span class="font-bold <?php echo e($index === 0 ? 'text-emerald-900' : 'text-amber-900'); ?>"><?php echo e(number_format($niveau->frais->frais_inscription, 0, ',', ' ')); ?> FCFA</span>
                                                                </div>
                                                            </div>
                                                        <?php endif; ?>
                                                    </div>
                                                <?php endif; ?>

                                                <!-- Section Matieres -->
                                                <?php if($niveau->matieres->count() > 0): ?>
                                                    <div>
                                                        <div class="flex items-center gap-2 mb-3">
                                                            <svg class="w-5 h-5 text-slate-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
                                                            </svg>
                                                            <h5 class="font-bold text-slate-900 text-sm">Matières enseignées</h5>
                                                            <span class="ml-auto text-xs bg-slate-100 text-slate-600 px-2 py-1 rounded-full font-medium"><?php echo e($niveau->matieres->count()); ?> matières</span>
                                                        </div>
                                                        <div class="space-y-2">
                                                            <?php $__currentLoopData = $niveau->matieres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $matiere): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <div class="flex items-center justify-between bg-slate-50 rounded-lg px-3 py-2 border border-slate-200">
                                                                    <span class="text-sm text-slate-700"><?php echo e($matiere->nom); ?></span>
                                                                    <span class="text-xs font-semibold <?php echo e($index === 0 ? 'text-emerald-600' : 'text-amber-600'); ?> bg-white px-2 py-1 rounded">Coef. <?php echo e($matiere->coefficient); ?></span>
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>

                                                <!-- Section Documents -->
                                                <?php if($niveau->documentsNiveau->count() > 0): ?>
                                                    <div>
                                                        <div class="flex items-center gap-2 mb-3">
                                                            <svg class="w-5 h-5 text-slate-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                                                            </svg>
                                                            <h5 class="font-bold text-slate-900 text-sm">Documents requis</h5>
                                                        </div>
                                                        <ul class="space-y-2">
                                                            <?php $__currentLoopData = $niveau->documentsNiveau; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <li class="flex items-start gap-2 text-sm">
                                                                    <svg class="w-4 h-4 <?php echo e($doc->obligatoire ? 'text-red-500' : 'text-green-500'); ?> mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="<?php echo e($doc->obligatoire ? 'M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z' : 'M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z'); ?>"/>
                                                                    </svg>
                                                                    <span class="text-slate-700">
                                                                        <?php echo e($doc->intitule); ?>

                                                                        <?php if($doc->obligatoire): ?>
                                                                            <span class="text-red-600 font-medium">(Obligatoire)</span>
                                                                        <?php else: ?>
                                                                            <span class="text-slate-600">(Optionnel)</span>
                                                                        <?php endif; ?>
                                                                    </span>
                                                                </li>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                    </div>
                                                <?php endif; ?>

                                                <!-- CTA Button -->
                                                <div class="pt-4">
                                                    <a href="<?php echo e(route('inscription', ['filiere' => $filiere->id, 'niveau' => $niveau->id])); ?>"
                                                       class="block w-full text-center bg-gradient-to-r <?php echo e($index === 0 ? 'from-emerald-600 to-emerald-700 hover:from-emerald-700 hover:to-emerald-800' : 'from-amber-600 to-amber-700 hover:from-amber-700 hover:to-amber-800'); ?> text-white font-bold py-4 px-6 rounded-xl transition-all duration-300 shadow-lg hover:shadow-xl transform hover:-translate-y-0.5">
                                                        <div class="flex items-center justify-center gap-2">
                                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                                            </svg>
                                                            <span>S'inscrire en <?php echo e($niveau->nom); ?></span>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>
</section>

<!-- Info Section -->
<section class="py-16 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="bg-gradient-to-r from-slate-900 to-slate-800 rounded-3xl p-8 lg:p-12">
            <div class="grid md:grid-cols-2 gap-8 items-center">
                <div>
                    <h2 class="text-2xl sm:text-3xl font-bold text-white mb-4">Besoin d'aide pour choisir ?</h2>
                    <p class="text-slate-300 leading-relaxed mb-6">
                        Notre équipe pédagogique est à votre disposition pour vous orienter vers la filière la plus adaptée à votre profil et vos objectifs professionnels.
                    </p>
                    <a href="<?php echo e(route('contact')); ?>" class="inline-flex items-center gap-2 px-6 py-3 bg-white text-slate-900 font-semibold rounded-xl hover:bg-slate-100 transition">
                        <span>Demander conseil</span>
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                        </svg>
                    </a>
                </div>
                <?php if($statistics->count() > 0): ?>
                <div class="grid grid-cols-2 gap-4">
                    <?php $__currentLoopData = $statistics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-white/10 rounded-xl p-4 text-center">
                        <div class="flex justify-center mb-2">
                            <?php if($stat->icone == 'chart'): ?>
                            <svg class="w-6 h-6 text-blue-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                            </svg>
                            <?php elseif($stat->icone == 'briefcase'): ?>
                            <svg class="w-6 h-6 text-blue-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                            </svg>
                            <?php elseif($stat->icone == 'users'): ?>
                            <svg class="w-6 h-6 text-blue-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/>
                            </svg>
                            <?php elseif($stat->icone == 'academic'): ?>
                            <svg class="w-6 h-6 text-blue-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path d="M12 14l9-5-9-5-9 5 9 5z"/>
                                <path d="M12 14l6.16-3.422a12.083 12.083 0 01.665 6.479A11.952 11.952 0 0012 20.055a11.952 11.952 0 00-6.824-2.998 12.078 12.078 0 01.665-6.479L12 14z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 14l9-5-9-5-9 5 9 5zm0 0l6.16-3.422a12.083 12.083 0 01.665 6.479A11.952 11.952 0 0012 20.055a11.952 11.952 0 00-6.824-2.998 12.078 12.078 0 01.665-6.479L12 14zm-4 6v-7.5l4-2.222"/>
                            </svg>
                            <?php elseif($stat->icone == 'clock'): ?>
                            <svg class="w-6 h-6 text-blue-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            <?php elseif($stat->icone == 'star'): ?>
                            <svg class="w-6 h-6 text-blue-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z"/>
                            </svg>
                            <?php endif; ?>
                        </div>
                        <div class="text-3xl font-bold text-white mb-1"><?php echo e($stat->valeur); ?></div>
                        <div class="text-slate-600 text-sm"><?php echo e($stat->libelle); ?></div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\istmat\resources\views/front/programmes.blade.php ENDPATH**/ ?>