<?php $__env->startSection('content'); ?>
<!-- Page Header -->
<section class="bg-gradient-to-r from-blue-900 to-blue-800 py-16">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center">
            <h1 class="text-4xl sm:text-5xl font-bold text-white mb-4">A propos de ISTMAD</h1>
            <p class="text-lg text-blue-100 max-w-2xl mx-auto">
                Decouvrez notre histoire, notre mission et nos valeurs
            </p>
        </div>
    </div>
</section>

<!-- Qui sommes-nous -->
<section class="py-20 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid lg:grid-cols-2 gap-12 items-center">
            <div>
                <span class="text-blue-600 font-semibold text-sm uppercase tracking-wider">Presentation</span>
                <h2 class="text-3xl sm:text-4xl font-bold text-slate-900 mt-2 mb-6">Qui sommes-nous ?</h2>
                <p class="text-slate-600 leading-relaxed mb-6 text-justify">
                    L'Institut Superieur de Technologie et Management (ISTMAD) est un etablissement d'enseignement superieur agree par le Ministere de l'Enseignement Superieur du Cameroun.
                </p>
                <p class="text-slate-600 leading-relaxed mb-6 text-justify">
                    Notre positionnement academique repose sur une offre de formation professionnalisante, orientee vers les besoins reels du marche de l'emploi. Nous proposons des filières BTS et HND reconnues, qui permettent a nos diplomes d'integrer rapidement le monde professionnel.
                </p>
                <p class="text-slate-600 leading-relaxed text-justify">
                    ISTMAD se distingue par son approche pedagogique equilibree, combinant enseignements theoriques solides et mise en pratique concrete a travers des stages en entreprise et des projets professionnels.
                </p>
            </div>
            <div class="bg-slate-200 rounded-2xl h-96 flex items-center justify-center overflow-hidden">
                <img src="<?php echo e(asset('images/istmat-apropos.jpg')); ?>" alt="ISTMAD Institution" class="w-full h-full object-cover" onerror="this.parentElement.innerHTML='<div class=\'text-center text-slate-500 p-8\'><svg class=\'w-20 h-20 mx-auto mb-4\' fill=\'none\' stroke=\'currentColor\' viewBox=\'0 0 24 24\'><path stroke-linecap=\'round\' stroke-linejoin=\'round\' stroke-width=\'2\' d=\'M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4\'/></svg><span class=\'text-lg\'>Image institutionnelle ISTMAD</span></div>'">
            </div>
        </div>
    </div>
</section>

<!-- Mission & Vision -->
<section class="py-20 bg-slate-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <span class="text-blue-600 font-semibold text-sm uppercase tracking-wider">Ce qui nous guide</span>
            <h2 class="text-3xl sm:text-4xl font-bold text-slate-900 mt-2">Notre mission et notre vision</h2>
        </div>

        <div class="grid md:grid-cols-2 gap-8">
            <div class="bg-white rounded-2xl p-8 shadow-sm border-l-4 border-blue-600">
                <div class="w-14 h-14 bg-blue-100 rounded-xl flex items-center justify-center mb-6">
                    <svg class="w-7 h-7 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                    </svg>
                </div>
                <h3 class="text-2xl font-bold text-slate-900 mb-4">Notre Mission</h3>
                <p class="text-slate-600 leading-relaxed text-justify">
                    Former des professionnels competents et operationnels, capables de repondre aux exigences du marche du travail local et international. Nous nous engageons a offrir une education de qualite, alliant theorie et pratique.
                </p>
            </div>

            <div class="bg-white rounded-2xl p-8 shadow-sm border-l-4 border-green-600">
                <div class="w-14 h-14 bg-green-100 rounded-xl flex items-center justify-center mb-6">
                    <svg class="w-7 h-7 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                    </svg>
                </div>
                <h3 class="text-2xl font-bold text-slate-900 mb-4">Notre Vision</h3>
                <p class="text-slate-600 leading-relaxed text-justify">
                    Devenir l'institution de reference en matiere de formation professionnelle au Cameroun et en Afrique centrale. Nous aspirons a etre reconnus pour l'excellence de nos formations et l'employabilite de nos diplomes.
                </p>
            </div>
        </div>
    </div>
</section>

<!-- Nos Valeurs Fondamentales -->
<section class="py-20 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <span class="text-blue-600 font-semibold text-sm uppercase tracking-wider">Nos principes</span>
            <h2 class="text-3xl sm:text-4xl font-bold text-slate-900 mt-2">Nos valeurs fondamentales</h2>
        </div>

        <div class="grid lg:grid-cols-2 gap-12 items-center">
            <!-- Video a gauche -->
            <div class="flex items-center justify-center">
                <div class="w-full max-w-md rounded-2xl overflow-hidden shadow-lg bg-slate-900">
                    <video
                        class="w-full h-full min-h-[32rem] object-cover"
                        autoplay
                        muted
                        loop
                        playsinline
                    >
                        <source src="<?php echo e(asset('videos/valeurs-istmad.mp4')); ?>" type="video/mp4">
                        <!-- Fallback si video non disponible -->
                        <div class="w-full h-72 bg-slate-800 flex items-center justify-center">
                            <div class="text-center text-slate-400">
                                <svg class="w-16 h-16 mx-auto mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14.752 11.168l-3.197-2.132A1 1 0 0010 9.87v4.263a1 1 0 001.555.832l3.197-2.132a1 1 0 000-1.664z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                                <p>Video ISTMAD</p>
                            </div>
                        </div>
                    </video>
                </div>
            </div>

            <!-- Valeurs en grille 2x2 a droite -->
            <div>
                <div class="grid grid-cols-2 gap-5">
                    <!-- Valeur 1 -->
                    <div class="bg-slate-50 rounded-xl p-6 border border-slate-200">
                        <div class="w-12 h-12 bg-sky-100 rounded-lg flex items-center justify-center mb-4">
                            <svg class="w-6 h-6 text-sky-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"/>
                            </svg>
                        </div>
                        <h3 class="text-lg font-bold text-slate-900 mb-2">Excellence</h3>
                        <p class="text-slate-600 text-sm">Viser le meilleur dans tout ce que nous faisons</p>
                    </div>

                    <!-- Valeur 2 -->
                    <div class="bg-slate-50 rounded-xl p-6 border border-slate-200">
                        <div class="w-12 h-12 bg-red-100 rounded-lg flex items-center justify-center mb-4">
                            <svg class="w-6 h-6 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/>
                            </svg>
                        </div>
                        <h3 class="text-lg font-bold text-slate-900 mb-2">Integrite</h3>
                        <p class="text-slate-600 text-sm">Agir avec honnetete et transparence</p>
                    </div>

                    <!-- Valeur 3 -->
                    <div class="bg-slate-50 rounded-xl p-6 border border-slate-200">
                        <div class="w-12 h-12 bg-sky-100 rounded-lg flex items-center justify-center mb-4">
                            <svg class="w-6 h-6 text-sky-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"/>
                            </svg>
                        </div>
                        <h3 class="text-lg font-bold text-slate-900 mb-2">Innovation</h3>
                        <p class="text-slate-600 text-sm">Adopter les methodes pedagogiques modernes</p>
                    </div>

                    <!-- Valeur 4 -->
                    <div class="bg-slate-50 rounded-xl p-6 border border-slate-200">
                        <div class="w-12 h-12 bg-red-100 rounded-lg flex items-center justify-center mb-4">
                            <svg class="w-6 h-6 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/>
                            </svg>
                        </div>
                        <h3 class="text-lg font-bold text-slate-900 mb-2">Engagement</h3>
                        <p class="text-slate-600 text-sm">Accompagner chaque etudiant vers la reussite</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- CTA -->
<section class="py-16 bg-slate-50">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-2xl sm:text-3xl font-bold text-slate-900 mb-4">Rejoignez notre communaute</h2>
        <p class="text-slate-600 mb-8">
            Decouvrez nos filières de formation et lancez votre carriere avec ISTMAD
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="<?php echo e(route('programmes')); ?>" class="px-8 py-3 bg-blue-900 text-white font-semibold rounded-xl hover:bg-blue-800 transition">
                Voir nos filières
            </a>
            <a href="<?php echo e(route('contact')); ?>" class="px-8 py-3 border-2 border-slate-300 text-slate-700 font-semibold rounded-xl hover:bg-slate-100 transition">
                Nous contacter
            </a>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\istmat\resources\views/front/a-propos.blade.php ENDPATH**/ ?>