<?php $__env->startSection('content'); ?>
<div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
    <div class="p-6 text-gray-900">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-3xl font-bold">Configuration Email</h1>
            <a href="<?php echo e(route('admin.dashboard')); ?>" class="text-indigo-600 hover:text-indigo-900">
                Retour au dashboard
            </a>
        </div>

        <?php if(session('success')): ?>
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <form method="POST" action="<?php echo e(route('admin.settings.email.update')); ?>">
            <?php echo csrf_field(); ?>

            <div class="bg-gray-50 p-4 rounded-lg mb-6">
                <div class="flex items-center mb-4">
                    <input type="checkbox" name="mail_enabled" id="mail_enabled" value="1"
                        <?php echo e($settings->mail_enabled ? 'checked' : ''); ?>

                        class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500">
                    <label for="mail_enabled" class="ml-2 text-sm font-medium text-gray-700">
                        Activer l'envoi d'emails
                    </label>
                </div>
                <p class="text-sm text-gray-500">
                    Si desactive, aucun email ne sera envoye depuis l'application.
                </p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                <div>
                    <label for="mail_mailer" class="block text-sm font-medium text-gray-700 mb-1">Type de mailer</label>
                    <select name="mail_mailer" id="mail_mailer"
                        class="w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        <option value="smtp" <?php echo e($settings->mail_mailer === 'smtp' ? 'selected' : ''); ?>>SMTP</option>
                        <option value="sendmail" <?php echo e($settings->mail_mailer === 'sendmail' ? 'selected' : ''); ?>>Sendmail</option>
                        <option value="log" <?php echo e($settings->mail_mailer === 'log' ? 'selected' : ''); ?>>Log (test)</option>
                    </select>
                </div>

                <div>
                    <label for="mail_encryption" class="block text-sm font-medium text-gray-700 mb-1">Chiffrement</label>
                    <select name="mail_encryption" id="mail_encryption"
                        class="w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        <option value="tls" <?php echo e($settings->mail_encryption === 'tls' ? 'selected' : ''); ?>>TLS</option>
                        <option value="ssl" <?php echo e($settings->mail_encryption === 'ssl' ? 'selected' : ''); ?>>SSL</option>
                        <option value="null" <?php echo e($settings->mail_encryption === 'null' || !$settings->mail_encryption ? 'selected' : ''); ?>>Aucun</option>
                    </select>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                <div>
                    <label for="mail_host" class="block text-sm font-medium text-gray-700 mb-1">Serveur SMTP</label>
                    <input type="text" name="mail_host" id="mail_host" value="<?php echo e($settings->mail_host); ?>"
                        placeholder="smtp.example.com"
                        class="w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>

                <div>
                    <label for="mail_port" class="block text-sm font-medium text-gray-700 mb-1">Port</label>
                    <input type="text" name="mail_port" id="mail_port" value="<?php echo e($settings->mail_port ?? '587'); ?>"
                        placeholder="587"
                        class="w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                <div>
                    <label for="mail_username" class="block text-sm font-medium text-gray-700 mb-1">Identifiant SMTP</label>
                    <input type="text" name="mail_username" id="mail_username" value="<?php echo e($settings->mail_username); ?>"
                        placeholder="votre@email.com"
                        class="w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>

                <div>
                    <label for="mail_password" class="block text-sm font-medium text-gray-700 mb-1">Mot de passe SMTP</label>
                    <input type="password" name="mail_password" id="mail_password" value="<?php echo e($settings->mail_password); ?>"
                        placeholder="••••••••"
                        class="w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                <div>
                    <label for="mail_from_address" class="block text-sm font-medium text-gray-700 mb-1">Email d'expedition</label>
                    <input type="email" name="mail_from_address" id="mail_from_address" value="<?php echo e($settings->mail_from_address); ?>"
                        placeholder="contact@istmat.com"
                        class="w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>

                <div>
                    <label for="mail_from_name" class="block text-sm font-medium text-gray-700 mb-1">Nom d'expediteur</label>
                    <input type="text" name="mail_from_name" id="mail_from_name" value="<?php echo e($settings->mail_from_name ?? 'ISTMAT'); ?>"
                        placeholder="ISTMAT"
                        class="w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
            </div>

            <div>
                <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded transition">
                    Enregistrer
                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\istmat\resources\views/admin/settings/email.blade.php ENDPATH**/ ?>